function [PZT_num]=PZT_Config(X,Y,X_final,Y_final)
% this function return the required pzt number to be activated based on
% required/desired direction.

% calculation of the desired direction using two points(current & final point) 
Delta_x=X_final-X;
Delta_y=Y_final-Y;
Req_dir = wrapTo2Pi(atan2(Delta_y,Delta_x));% desired direction

 if (Req_dir > 0.7850) && (Req_dir < 2.3550)
     PZT_num = 4;    % disp('% both pzts')
     elseif (Req_dir > 3.9250) && (Req_dir < 5.4950)
         PZT_num = 3;     %disp('% both pzts')
         elseif (Req_dir >= 2.3550) && (Req_dir <= 3.9250)
             PZT_num = 2;    % disp('% left pzt')
             else
                 PZT_num = 1;    % disp('% right pzt')
 end
end
 
 
